IF EXISTS
(
	SELECT *
	FROM sys.objects
	WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_APLICAR]')
		  AND type IN(N'P', N'PC')
)
	DROP PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_APLICAR];
GO
GO
--EXEC P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_APLICAR 39
CREATE PROCEDURE P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_APLICAR (@CD_CTR_PAR INT=0, @REAPLICAR INT=0)
AS
	SET NOCOUNT ON;
	DECLARE @TIPO_TRANSACAO INT
	DECLARE @CD_CTR INT

	DECLARE ProcLotePerfil CURSOR FAST_FORWARD FOR 
	SELECT
		l.CD_CTR,
		l.TIPO_TRANSACAO
	FROM
		EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO l
	WHERE
		L.STS_LOTE = CASE WHEN @REAPLICAR = 1 THEN L.STS_LOTE ELSE 0 END  
		AND L.CD_CTR = CASE WHEN @CD_CTR_PAR =0 THEN L.CD_CTR ELSE @CD_CTR_PAR END
	
	OPEN ProcLotePerfil;
	FETCH NEXT FROM ProcLotePerfil INTO
									@CD_CTR,
									@TIPO_TRANSACAO;
WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT 'Lote.: ' + CONVERT(VARCHAR(20),@CD_CTR)  
		--Lote de inclusao
		IF @TIPO_TRANSACAO = 0
		BEGIN
			PRINT 'Inclusao'
			EXEC P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_INCLUIR @CD_CTR,@REAPLICAR
		END

		--Lote de excusao
		IF @TIPO_TRANSACAO = 1
		BEGIN
			PRINT 'Exclusao'
			EXEC P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EXCLUIR @CD_CTR,@REAPLICAR
		END

		--Marcado lote como processado
		update
			LP
		set 
			LP.STS_LOTE=1
		from
			EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO LP 
		where
			CD_CTR=@CD_CTR
	
	FETCH NEXT FROM ProcLotePerfil INTO
									@CD_CTR,
									@TIPO_TRANSACAO;
	END;

CLOSE ProcLotePerfil;
DEALLOCATE ProcLotePerfil;
	